	function [s_of_t, t_axis] = PZ_2_STEP_RESPONSE_S(G, Z, P, t_axis)
	
	%	Computes the step response of a causal analog filter 
	%	over the time interval given by t_axis from the poles and zeros.
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 2006-02-27
	% 	Modified by: 	LW 2010-04-16 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1 
	% 	Known bugs:	 
	% 	Report bugs to:	Wanhammar@gmail.com
	
	%========================================================	
	
	P = [P; 0];
	[Residues, P, Mult] = PART_FRACT_EXPANSION(G, Z, P);
	s_of_t = zeros(1,length(t_axis));
	for k = 1:length(Residues)
		m = max(0, Mult(k)-1);
		s_of_t = s_of_t + (Residues(k)/prod(1:m))*t_axis.^m.*exp(P(k).*t_axis);		
	end
	s_of_t = real(s_of_t);
	% The step response at t = 0 is = sum(Residues)
	
